# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2017-08-11 08:35


from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0008_alter_user_username_max_length'),
    ]

    operations = [
        migrations.CreateModel(
            name='Person',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='last login')),
                ('uid', models.BigIntegerField(unique=True)),
                ('login', models.CharField(max_length=50, unique=True)),
                ('is_dismissed', models.BooleanField(db_index=True, default=False)),
                ('is_robot', models.BooleanField(db_index=True, default=False)),
                ('gender', models.CharField(choices=[('m', 'male'), ('f', 'female')], default='m', max_length=1)),
                ('first_name_ru', models.CharField(blank=True, max_length=50)),
                ('last_name_ru', models.CharField(blank=True, max_length=50)),
                ('first_name_en', models.CharField(blank=True, max_length=50)),
                ('last_name_en', models.CharField(blank=True, max_length=50)),
                ('city_name_ru', models.TextField(default='')),
                ('city_name_en', models.TextField(default='')),
                ('position_ru', models.TextField(default='')),
                ('position_en', models.TextField(default='')),
                ('join_at', models.DateField(default=None, null=True)),
                ('work_email', models.CharField(default='', max_length=100)),
                ('language', models.CharField(default='ru', max_length=10)),
                ('created_at_auto', models.DateTimeField(auto_now_add=True)),
                ('updated_at_auto', models.DateTimeField(auto_now=True)),
                ('password', models.CharField(default='', max_length=128, verbose_name='password')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Department',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('path', models.CharField(max_length=255, unique=True)),
                ('depth', models.PositiveIntegerField()),
                ('numchild', models.PositiveIntegerField(default=0)),
                ('name_ru', models.CharField(max_length=255)),
                ('name_en', models.CharField(default='', max_length=255)),
                ('slug', models.CharField(max_length=255, unique=True)),
                ('created_at_auto', models.DateTimeField(auto_now_add=True)),
                ('updated_at_auto', models.DateTimeField(auto_now=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DepartmentRole',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('type', models.CharField(choices=[('h', 'head'), ('d', 'deputy')], db_index=True, max_length=1)),
                ('created_at_auto', models.DateTimeField(auto_now_add=True)),
                ('updated_at_auto', models.DateTimeField(auto_now=True)),
                ('department', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='roles', related_query_name='role', to='staff.Department')),
                ('person', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='roles', related_query_name='role', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Subordination',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('type', models.CharField(choices=[('i', 'indirect'), ('d', 'direct')], db_index=True, max_length=1)),
                ('position', models.SmallIntegerField(default=0)),
                ('created_at_auto', models.DateTimeField(auto_now_add=True)),
                ('updated_at_auto', models.DateTimeField(auto_now=True)),
                ('object', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='superiors', related_query_name='superior', to=settings.AUTH_USER_MODEL)),
                ('subject', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='subordinates', related_query_name='subordinate', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.AddField(
            model_name='person',
            name='department',
            field=models.ForeignKey(default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='persons', related_query_name='person', to='staff.Department'),
        ),
        migrations.AddField(
            model_name='person',
            name='groups',
            field=models.ManyToManyField(blank=True, help_text='The groups this user belongs to. A user will get all permissions granted to each of their groups.', related_name='user_set', related_query_name='user', to='auth.Group', verbose_name='groups'),
        ),
        migrations.AddField(
            model_name='person',
            name='user_permissions',
            field=models.ManyToManyField(blank=True, help_text='Specific permissions for this user.', related_name='user_set', related_query_name='user', to='auth.Permission', verbose_name='user permissions'),
        ),
        migrations.AlterUniqueTogether(
            name='subordination',
            unique_together=set([('subject', 'object', 'position')]),
        ),
        migrations.AlterIndexTogether(
            name='subordination',
            index_together=set([('subject', 'type'), ('object', 'type')]),
        ),
        migrations.AlterUniqueTogether(
            name='departmentrole',
            unique_together=set([('person', 'department', 'type')]),
        ),
        migrations.AlterIndexTogether(
            name='departmentrole',
            index_together=set([('person', 'type')]),
        ),
    ]
