

from review.lib.serializers import BaseSerializer, F
from review.staff import const as staff_const


class PersonSerializer(BaseSerializer):
    fields = {
        'id',
        'login',
        'is_dismissed',
        F('gender', verbose=staff_const.GENDER.VERBOSE),
        F('position', source='position_ru'),
        F('first_name', source='first_name_?language?'),
        F('last_name', source='last_name_?language?'),
        F('department_slug', source='department.slug'),
        F('department_name', source='department.name_?language?'),
    }

    default_fields = {
        'id',
        'login',
        'gender',
        'first_name',
        'last_name',
    }
