import arrow
from django.db.models import Min

from review.staff import models


def get_stat():
    earliest_non_processed = models.StaffStructureChange.objects.filter(
        created_at_auto__contains=arrow.now('UTC').date(),
        processed_at=None,
    ).aggregate(Min('created_at_auto'))['created_at_auto__min']
    if earliest_non_processed is None:
        delay = 0
    else:
        earliest_non_processed = arrow.get(earliest_non_processed)
        delay = (arrow.now('UTC').datetime - earliest_non_processed).seconds // 60
    return [
        ['staff_structure_delay_max', delay],
    ]
