from django.conf import settings
from django_ids.auth import Auth
from django_ids.connector.http import HttpConnector

from review.lib.tvm2_client import get_service_ticket
from review.staff import const


class StaffConnector(HttpConnector):
    default_connect_timeout = 10

    url_prefix = '/'

    url_patterns = {
        const.PERSON_WITH_HEADS: 'api/staff_with_chiefs/',
        const.UMBRELLAS_ENGAGEMENT: 'umbrellas/export_umbrella_assignments/',
        const.UMBRELLAS: 'umbrellas/export_umbrellas/',
        const.VS_ENGAGEMENT: 'budget-position-api/export-person-value-streams/',
    }

    def __init__(self, **kwargs):
        protocol = kwargs.pop('protocol', settings.STAFF_PROTOCOL)
        host = kwargs.pop('host', settings.STAFF_HOST)
        retries = kwargs.pop('retries', 5)
        auth = kwargs.pop('auth', Auth(oauth_token=settings.ROBOT_OAUTH_TOKEN))
        super(StaffConnector, self).__init__(
            host=host,
            protocol=protocol,
            retries=retries,
            auth=auth,
            **kwargs
        )

    def prepare_params(self, params):
        headers = params.setdefault('headers')
        headers['X-Ya-Service-Ticket'] = get_service_ticket(settings.TVM_APP_IDS['staff'])
