# coding: utf-8
import waffle

from review.lib import lock
from review.staff.sync import store
from review.staff.sync import fetch_structure


@lock.get_lock_or_do_nothing_task
def sync_staff_full():
    """ Superior chains for Staff structure change requests are syncing independently """
    return store.sync_staff_full()


@lock.get_lock_or_do_nothing_task
def sync_staff_structure():
    if waffle.switch_is_active('skip_structure_sync'):
        return

    return fetch_structure.get_persons_at_staff_change()
