from django.conf import settings

from pymongo import MongoClient
from pymongo.read_preferences import ReadPreference


class CeleryStats:
    def __init__(self):
        self._broker_messages_collection = None

    @property
    def messages(self):
        if self._broker_messages_collection is not None:
            return self._broker_messages_collection

        connection = MongoClient(
            host=settings.BROKER_URL,
            read_preference=ReadPreference.PRIMARY_PREFERRED,
            username=settings.MONGO_DB_USER,
            password=settings.MONGO_DB_PASSWORD,
            authSource=settings.MONGO_DB_NAME,
        )
        self._broker_messages_collection = connection[settings.MONGO_DB_NAME]['messages']
        return self._broker_messages_collection

    @property
    def query(self):
        queues = [
            route_options['queue']
            for route_options in settings.CELERY_TASK_ROUTES.values()
        ] + [settings.CELERY_DEFAULT_QUEUE]
        return {'$or': [{'queue': q} for q in set(queues)]}

    def get_queue_size(self):
        return self.messages.find(self.query).count()

    def get_stat(self):
        return [
            ['celery_queue_size_max', self.get_queue_size()],
        ]
