# coding: utf-8

from django.conf import settings
from django.conf.urls import url, include
from django.views.generic import RedirectView
from django.contrib import admin
from django.contrib.staticfiles import views
import yenv

urlpatterns = [
    url(r'^' + settings.IDM_URL_PREFIX, include('django_idm_api.urls')),
    url(r'^admin/', admin.site.urls),
    url(r'^stat/', include('review.stats.urls')),
]

if 'backend' in settings.DEPLOY_MODE:
    urlpatterns.extend([
        url(r'^frontend/', include('review.frontend.urls')),
        url(r'^dev/', include('review.dev.urls')),
        url(r'^oebs/', include('review.oebs.urls')),
        url(r'^compensations/', include('review.compensations.urls', namespace='compensations_api')),
    ])
    if yenv.type not in ('prestable', 'production'):
        urlpatterns.extend((
            url(r'^notifications/', include('review.notifications.urls')),
            url(r'^maintenance/', include('cia_stuff.common.urls')),
        ))

if 'api' in settings.DEPLOY_MODE:
    urlpatterns.append(
        url(r'^v1/', include('review.api.urls')),
    )

if 'external' in settings.DEPLOY_MODE:
    urlpatterns.append(
        url(r'^external/', include('review.external.urls')),
    )

if settings.DEBUG:
    try:
        import debug_toolbar

        from debug_panel import urls as debug_urls

        urlpatterns += [
            url(r'^__debug__/', include(debug_toolbar.urls)),

            # annoying error when resolving this
            url(r'^favicon.ico$', RedirectView.as_view()),
            url(r'^static/(?P<path>.*)$', views.serve),
        ] + debug_urls.urlpatterns

    except ImportError:
        pass
