from django.conf import settings
from logging import getLogger

from review.xiva.tasks import send_post_to_xiva


log = getLogger(__name__)


def post_task_status_to_xiva(uid, event, message, **kwargs):
    xiva_url = settings.XIVA_SEND_URL_FORMAT.format(
        topic=f'pending-task-status-for-{uid}',
        event=event,
    )
    log.info('Send task info %s to xiva with kwargs %s', message, kwargs)
    send_post_to_xiva(xiva_url, message, **kwargs)
