import requests
from django.conf import settings
from logging import getLogger

from review.celery_app import app

log = getLogger(__name__)


def send_post_to_xiva(url, message, delay=True, **kwargs):
    post_data = {'payload': message}
    post_data.update(kwargs)
    if delay:
        send_post_to_xiva_task.delay(url, post_data)
    else:
        try:
            send_post_to_xiva_task(url, post_data)
        except requests.HTTPError as err:
            log.error('Post request to {}: {}'.format(url, err.message))
        else:
            log.debug('Post request to {}: ok'.format(url))


@app.task(
    bind=True,
    autoretry_for=(requests.HTTPError,),
    retry_kwargs={'max_retries': 5, 'countdown': 2}
)
def send_post_to_xiva_task(self, url, post_data):
    response = requests.post(
        url=url,
        headers={
            'Authorization': 'Xiva {}'.format(settings.XIVA_API_OAUTH_TOKEN),
            'X-Request-Timeout': '2000',
            'X-Request-Attempt': str(self.request.retries),
        },
        timeout=2,
        json=post_data,
    )
    response.raise_for_status()
