#!/usr/bin/env python

from tornado import web, autoreload, ioloop, locale, options, httpserver

from intranet.search.settings.utils import setup_environ
setup_environ(django_settings_module='intranet.search.abovemeta.settings')

from django.conf import settings

from intranet.search.abovemeta.handlers import (
    IsearchHandler,
    BisearchHandler,
    IsearchSuggestHandler,
    BisearchSuggestHandler,
    IsearchOpenSearchHandler,
    BisearchOpenSearchHandler,
    PingHandler,
)


if settings.APP_NAME == 'bisearch':
    handlers = [
        (r'/', BisearchHandler),
        (r'/suggest/', BisearchSuggestHandler),
        (r'/opensearch/', BisearchOpenSearchHandler),
    ]
else:
    handlers = [
        (r'/', IsearchHandler),
        (r'/suggest/', IsearchSuggestHandler),
        (r'/opensearch/', IsearchOpenSearchHandler),
    ]

handlers.extend([
    (r'/ping/?', PingHandler),
])


application = web.Application(handlers, serve_traceback=True, debug=settings.DEBUG)


def main():
    locale.load_gettext_translations(settings.BASE_LOCAL_PATH, 'abovemeta')
    options.define('bind', default=80, type=int)
    options.define('processes', default=9, type=int)
    options.parse_command_line()
    args = options.options

    http_server = httpserver.HTTPServer(application)
    http_server.bind(args.bind)
    http_server.start(1 if settings.DEBUG else args.processes)
    autoreload.start()
    ioloop.IOLoop.instance().start()
