from collections import defaultdict
from importlib import import_module

from django.conf import settings


rules = import_module('intranet.search.abovemeta.decider.rules.%s_rules' % settings.APP_NAME)
definitions = rules.definitions

definitions_by_language_scope = defaultdict(lambda: defaultdict(list))

for rule in definitions:
    for scope in rule.scope:
        for language in rule.language:
            definitions_by_language_scope[(language, scope)][rule.zone].append(rule)
