class Rule:
    def __init__(self, search=None, name=None, scope=None, zone=None,
                 trigger=None, language=None, attributes=None,
                 formula=None, groupings=None, collection=None):

        if None in [search, name, scope, zone, trigger]:
            raise ValueError('None is unacceptable here!')

        self.search = search
        self.collection = collection or ''
        self.name = name
        self.scope = scope
        self.zone = zone
        self.trigger = trigger

        self.language = language or ['ru', 'en']

        self.formula = formula
        self.attributes = attributes
        self.groupings = groupings

    def __repr__(self):
        return '<Rule: %s>' % {
            'name': self.name,
            'scope': self.scope,
            'zone': self.zone,
            'search': self.search,
            'collection': self.collection,
        }
