from intranet.search.abovemeta.decider.rules.base import Rule
from intranet.search.abovemeta.decider import triggers
from intranet.search.core.query import parse_query as pq

definitions = [
    Rule(
        search='directory',
        name='directory',
        scope=['directory'],
        zone='search_results',
        trigger=triggers.Always(),
    ),
    Rule(
        search='meta',
        collection='departments_groups',
        name='departments-groups',
        scope=['directory'],
        zone='wizard',
        trigger=triggers.Always(),
    ),
    Rule(
        search='wiki',
        collection='bisearch',
        name='wiki',
        scope=['wiki'],
        zone='search_results',
        trigger=triggers.Always(),
    ),
    Rule(
        search='directory',
        collection='',
        name='directory',
        scope=['wiki'],
        zone='wizard',
        trigger=triggers.Any(
            triggers.SearchTrigger(
                'directory',
                weight=0.9,
                query=pq('#{qtree}#'),
            ),
        ),
        groupings=[{'per_page': 2, 'per_group': 1}],
    ),
    Rule(
        search='tracker',
        collection='bisearch',
        name='tracker',
        scope=['tracker'],
        zone='search_results',
        trigger=triggers.Always(),
    ),
]
