from collections import namedtuple

import requests

TYPE_WARNING = 'warning'
TYPE_ERROR = 'error'
TYPE_REDIRECT = 'redirect'

# неизвестная ошибка
ERROR_UNKNOWN = 'ERROR_UNKNOWN'
# не найден указанный scope
REDIRECT_UNKNOWN_SCOPE = 'REDIRECT_UNKNOWN_SCOPE'
# ошибка валидации формы запроса
ERROR_VALIDATION = 'ERROR_VALIDATION'
# ошибка авторизации
ERROR_AUTH = 'ERROR_AUTH'
# ошибка прав доступа
ERROR_ACL = 'ERROR_ACL'
# ошибка на стадии выбора поисковика
ERROR_SEARCH_DECIDER = 'ERROR_SEARCH_DECIDER'
# ошибка получения списка ревизий
ERROR_REVISIONS = 'ERROR_REVISIONS'
# нет текста запроса
WARNING_EMPTY_QUERY = 'WARNING_EMPTY_QUERY'
# слишком длинный запрос
WARNING_LONG_QUERY = 'WARNING_LONG_QUERY'
# не найдено в основной выдаче, но есть колдунщики
WARNING_SPECIFY_REQUEST = 'WARNING_SPECIFY_REQUEST'
# если не найдено ничего нигде
WARNING_NOTHING_FOUND = 'WARNING_NOTHING_FOUND'
# если не смогли поискать везде
WARNING_INCOMPLETE_RESPONSE = 'WARNING_INCOMPLETE_RESPONSE'
# корректный пользователь, но который не имеет связи с организацией
REDIRECT_USER_ORGANIZATION = 'REDIRECT_USER_ORGANIZATION'
# внешний админ с несколькими организациями, у которого не указана организация в запросе
ERROR_SPECIFY_ORGANIZATION = 'ERROR_SPECIFY_ORGANIZATION'
# внешний админ пытается получить доступ к неизвестной для него организации
ERROR_UNKNOWN_ORGANIZATION = 'ERROR_UNKNOWN_ORGANIZATION'

# любая ошибка получения данных от диркетории
ERROR_DIRECTORY = 'ERROR_DIRECTORY'

ERRORS = {
    ERROR_UNKNOWN: (TYPE_ERROR, requests.codes.OK),
    REDIRECT_UNKNOWN_SCOPE: (TYPE_REDIRECT, requests.codes.NOT_FOUND),
    ERROR_VALIDATION: (TYPE_ERROR, requests.codes.BAD_REQUEST),
    ERROR_AUTH: (TYPE_ERROR, requests.codes.FORBIDDEN),
    ERROR_ACL: (TYPE_ERROR, requests.codes.FORBIDDEN),
    ERROR_REVISIONS: (TYPE_ERROR, requests.codes.NOT_FOUND),
    REDIRECT_USER_ORGANIZATION: (TYPE_REDIRECT, requests.codes.FORBIDDEN),
    ERROR_SPECIFY_ORGANIZATION: (TYPE_ERROR, requests.codes.BAD_REQUEST),
    ERROR_UNKNOWN_ORGANIZATION: (TYPE_ERROR, requests.codes.FORBIDDEN),
    ERROR_DIRECTORY: (TYPE_ERROR, requests.codes.FORBIDDEN),
    ERROR_SEARCH_DECIDER: (TYPE_ERROR, requests.codes.NOT_FOUND),
    WARNING_EMPTY_QUERY: (TYPE_WARNING, requests.codes.OK),
    WARNING_LONG_QUERY: (TYPE_WARNING, requests.codes.OK),
    WARNING_SPECIFY_REQUEST: (TYPE_WARNING, requests.codes.OK),
    WARNING_NOTHING_FOUND: (TYPE_WARNING, requests.codes.OK),
    WARNING_INCOMPLETE_RESPONSE: (TYPE_WARNING, requests.codes.OK),
}

AbovemetaError = namedtuple('AbovemetaError', ('type', 'code', 'message'))
