import copy
import logging

from django.conf import settings

from intranet.search.abovemeta import request_builders, search_response

log = logging.getLogger(__name__)

searches = dict(settings.ISEARCH.get('searches', {}).get('meta', {}),
                **settings.ISEARCH.get('searches', {}).get('base', {}))


# TODO: кажется это тоже что-то вроде поискового контекста, но я не буду его так называть
# в общем тут должно быть все про настройки для поиска


def sources_for_meta(collection_name):
    # Возвращает [(имя источника, индекс), ...] для метапоиска на платформе
    sources = searches['meta']['collections'][collection_name]['sources']
    result = [(source, value) for (source, settings) in sources.items() for value in settings['collection']]
    return result


def collection_for_search(search, collection):
    for col in [collection, '']:
        try:
            return searches[search]['collections'][col], col
        except KeyError:
            continue

    return settings.ISEARCH['searches']['external'][search]['collections'][collection], collection


def _get_collection_endpoint(service):
    """Формирует endpoint для переданной ревизии
    """
    endpoint = copy.deepcopy(settings.ISEARCH['api']['saas'][service]['search'])

    endpoint.setdefault('query', {})
    # Пока старый и новый поиск сосуществуют, в настройках есть лишние параметры
    endpoint['query'].pop('service', None)

    return endpoint


def _get_collection_request_builder(collection):
    rb_name = collection.get('request_builder', 'CommonSearch')
    return getattr(request_builders, rb_name)


def _get_collection_response_class(collection):
    class_name = collection.get('response_class', 'SaaSSearchResponse')
    return getattr(search_response, class_name)


def _revisions_for_search(state, search, index, collection_name):
    if search == 'meta':
        sources = sources_for_meta(collection_name)
    else:
        sources = [(search, index)]

    revisions = []
    for source, source_index in sources:
        revision = state.get_revision(source, source_index or '')
        if revision is None:
            log.warning(
                'No revision found. search %s, index: %s, organization_id: %s',
                source, source_index, state.org_directory_id,
                extra={'state': state}
            )
            continue
        revisions.append(revision)

    return sorted(revisions, key=lambda revision: revision['service'])


def prepare_search(state, search, collection, settings_name='default'):
    if state.debug:
        log.info(
            'prepare_search arguments, search: %s, collection: %s, settings_name: %s',
            search, collection, settings_name
        )
    collection, collection_name = collection_for_search(search, collection)

    index = collection.get('index', collection_name)

    formula, additional = state.get_formula(search, index, settings_name)

    if state.debug:
        log.info(
            'get_formula result: formula %s, additional %s',
            formula, additional
        )

    if additional:
        formula = ';'.join([formula, additional])

    wizard_rules, wizard_params = state.get_ew_rules(search, index, settings_name)

    if state.debug:
        log.info(
            'get_ew_rules result, wizard_rules: %s, wizard_params: %s',
            wizard_rules, wizard_params
        )

    revisions = _revisions_for_search(state, search, index, collection_name)

    if state.debug:
        log.info(
            '_revisions_for_search result, revisions: %s',
            revisions
        )

    if not revisions and not collection.get('external'):
        return None

    endpoint = _get_collection_endpoint(revisions[0]['service']) if revisions else None
    request_builder = _get_collection_request_builder(collection)
    response_class = _get_collection_response_class(collection)

    if state.debug:
        log.info(
            'request_builder and response_class are constructed'
        )
    # TODO: перетащить куда-то - куда?
    search_settings = {
        'endpoint': endpoint,
        'request_builder': request_builder,
        'response_class': response_class,
        'formula': formula,
        'wizard_rules': wizard_rules,
        'wizard_params': wizard_params,
        'revisions': revisions,
        'index': index,
        'collection_name': collection_name,
    }

    return search_settings
