import logging

from intranet.search.core.sources.utils import get_document_url
from intranet.search.abovemeta.serializers import isearch_serializers

log = logging.getLogger(__name__)


def get_avatar_url(snippet, size='islands-middle'):
    avatar_id = snippet.get('avatar_id')
    if not avatar_id:
        return get_document_url('avatar_stub').format(size=size)
    return get_document_url('avatar').format(avatar_id=avatar_id, size=size)


def suggest_people_serializer(snippet, doc):
    log.info('suggest_people_serializer: snippet %s(%s), doc %s(%s)', type(snippet), snippet, type(doc), doc)
    department_name = snippet['department'].get('dep_name') if snippet.get('department') else ''
    title = ('{} {}'.format(snippet['name']['first'] or '', snippet['name']['last'] or '')).strip()
    if not title:
        title = snippet['login']

    return {
        'title': title,
        'url': snippet['url'],
        'id': str(snippet['uid']),
        'cloud_uid': snippet.get('cloud_uid'),
        'fields': [
            {'type': 'login', 'value': snippet['login']},
            {'type': 'department_name', 'value': department_name},
            {'type': 'is_dismissed', 'value': snippet['is_dismissed']},
            {'type': 'avatar_url', 'value': get_avatar_url(snippet)},
        ]
    }


def suggest_b2b_people_serializer(snippet, doc):
    return suggest_people_serializer(snippet, doc)


def suggest_queues_serializer(snippet, doc):
    return isearch_serializers.suggest_queues_serializer(snippet, doc)


def suggest_b2b_queues_serializer(snippet, doc):
    return isearch_serializers.suggest_queues_serializer(snippet, doc)


def suggest_issues_serializer(snippet, doc):
    return isearch_serializers.suggest_issues_serializer(snippet, doc)


def suggest_b2b_issues_serializer(snippet, doc):
    return isearch_serializers.suggest_issues_serializer(snippet, doc)


def search_directory_serializer(snippet, doc):
    snippet['avatar_url'] = get_avatar_url(snippet, size='islands-150')
    return snippet


def search_tracker_bisearch_serializer(snippet, doc):
    return isearch_serializers.search_st_serializer(snippet, doc)


def search_wiki_bisearch_serializer(snippet, doc):
    return isearch_serializers.search_wiki_serializer(snippet, doc)
