from logging import Logger

from ylog.context import log_context

from intranet.search.settings.django.settings import *  # noqa: ImportStarUsed


class AbovemetaContextLogging(Logger):
    """ Логгер для abovemeta, вытаскивающий контекст из state и
    передающий его в log_context.
    Необходим, потому что в торнадо нельзя обернуть в log_context вызов get.

    Добавляет в контекст всё, что указано в extra['context'], а также,
    если указана extra['state'] добавляет в контекст данные из state.get_log_context()
    """

    def _log(self, level, msg, args, exc_info=None, extra=None):
        state = extra and extra.pop('state', None)
        context = state.get_log_context() if state else {}
        if extra:
            context.update(extra.pop('context', {}))
        with log_context(**context):
            super()._log(level, msg, args, exc_info, extra)


logging.setLoggerClass(AbovemetaContextLogging)  # noqa: ImportStarUsage

ISEARCH_ABOVEMETA_HTTP_CACHE_TIMEOUT = 300
