from django.conf import settings
from tornado import gen
from tornado.httpclient import HTTPResponse

from intranet.search.abovemeta.request import Request

from .base import HttpStep, timeouts


def _serialize_name(name):
    return {
        'first_name': name.get('FirstName'),
        'last_name': name.get('LastName'),
        'middle_name': name.get('Patronymic'),
    }


class BegemotStep(HttpStep):
    """
    Шаг получения контекста запроса с помощью Бегемота.
    Сейчас поддерживает только распознавание ФИО.
    """

    def get_future(self, state, requester):
        if not state.text:
            future = gen.Future()
            future.set_result({})
            return future

        return super().get_future(state, requester)

    def process_response(self, state, response):
        if not response or isinstance(response, HTTPResponse):
            parsed = super().process_response(state, response)
        else:
            parsed = response
            self.set_data(state, parsed)
        return parsed

    def get_request(self, state):
        endpoint = settings.ISEARCH['api']['begemot']['markup']
        url = endpoint.url(query=self.get_query(state))
        return Request(
            url=url,
            type_='api',
            name='begemot',
            request_timeout=timeouts['begemot'],
            retries=1,
        )

    def get_query(self, state):
        return {
            'text': state.text,
        }

    def set_data(self, state, data):
        state.people_names = [_serialize_name(name) for name in data.get('Fio', [])]
