from django.conf import settings

from intranet.search.abovemeta import errors
from intranet.search.abovemeta.request import Request

from .base import HttpStep, timeouts


class ConductorUserStep(HttpStep):
    """ Шаг получения информации о правах пользователя кондуктора.

    Если пользователя нет в кондукторе или у него нет роли, то прав на
    поиск по кондуктору у него нет.
    """
    def get_request(self, state):
        endpoint = settings.ISEARCH['api']['conductor']['user']

        url = endpoint.url().format(user=state.user)

        return Request(
            url=url,
            type_='conductor',
            name='conductor_user',
            headers=endpoint.headers(),
            request_timeout=timeouts['groups'],
        )

    def set_data(self, state, response):
        if response.get("value", {}).get("role"):
            state.conductor_user_role = response["value"]["role"]
        else:
            self.set_error(state, response)

    def set_error(self, state, response):
        if settings.DEBUG and state.feature_enabled('ignore_conductor_auth'):
            # На тестинге кондуктора часто сбрасываются поля пользователя,
            # поэтому делаем backdoor для своих
            return
        state.set_error(errors.ERROR_ACL, 'You do not have permission for conductor search')
