from intranet.search.abovemeta.request import Request

from .base import HttpStep, api_urls, timeouts


class ExternalWizardStep(HttpStep):
    def get_request(self, state):
        endpoint = api_urls['external_wizard_rules']
        query = {'json': 1}
        return Request(
            url=endpoint.url(query=query),
            type_='api',
            name='external_wizard_rules',
            headers=endpoint.get('headers', {}),
            request_timeout=timeouts['default'],
        )

    def set_data(self, state, data):
        rules = {(r['search'], r['index'], r['name']): r for r in data}
        state.external_wizard_rules = rules
