from intranet.search.abovemeta.request import Request

from .base import HttpStep, api_urls, timeouts


class FeaturesStep(HttpStep):
    def get_request(self, state):
        endpoint = api_urls['features']

        query = {
            'user': state.user,
            'groups': state.groups,
            'json': True,
            'request_id': state.request_id,
        }

        return Request(
            url=endpoint.url(query=query),
            type_='api',
            name='features',
            headers=endpoint.get('headers', {}),
            request_timeout=timeouts['features'],
        )

    def set_data(self, state, features_data):
        state.update_features(features_data)
