from intranet.search.abovemeta.request import Request

from .base import HttpStep, api_urls, timeouts


class FormulasStep(HttpStep):
    def get_request(self, state):
        endpoint = api_urls['formulas']
        query = {
            'json': 1,
            'request_id': state.request_id,
        }

        return Request(
            url=endpoint.url(query=query),
            type_='api',
            name='formulas',
            headers=endpoint.get('headers', {}),
            request_timeout=timeouts['revisions'],
        )

    def set_data(self, state, data):
        formulas = {
            (f['search'], f['index'], f['service'], f['name']): f
            for f in data
        }
        state.formulas = formulas
