from django.conf import settings

from intranet.search.abovemeta.request import Request

from .base import HttpStep, timeouts


class QueuesStep(HttpStep):
    def get_request(self, state):
        endpoint = settings.ISEARCH['api']['st']['user_queue']

        url = endpoint.url().format(user=state.user)

        return Request(
            url=url,
            type_='st',
            name='queues',
            headers=endpoint.headers(),
            request_timeout=timeouts['groups'],
        )

    def set_data(self, state, data):
        state.user_queues = [q['id'] for q in data]
