from django.conf.urls import url
from intranet.search.admin.admin.views import (
    external_wizard_rules,
    factors,
    features,
    formula,
    jobs,
    organization,
    profile,
    pushes,
    search,
    sources,
    suggest,
)


urlpatterns = [
    url(r'search/viewer/search/$', search.search_viewer, name='isearch-viewer-search'),
    url(r'search/viewer/suggest/$', suggest.suggest_viewer, name='isearch-viewer-suggest'),
    url(r'search/viewer/factors/$', factors.factors_viewer, name='isearch-viewer-factors'),
    url(r'search/suggest/$', suggest.suggest, name='isearch-suggest'),

    url(r'sources/$', sources.sources, name='isearch-sources'),

    url(r'sources/(\w+)/(\w*)/revisions$', sources.sources_revision_list,
        name='isearch-sources-revision-list'),
    url(r'sources/(\w+)/(\w*)/revisions/([0-9]+)$', sources.sources_revision,
        name='isearch-sources-revision'),
    url(r'sources/revision/manage$', sources.sources_manage_revision,
        name='isearch-sources-manage-revision'),

    url(r'sources/(\w+)/(\w*)/indexations/(\d+)$', sources.sources_indexation,
        name='isearch-sources-indexation'),
    url(r'sources/(\w+)/(\w*)/indexations/?$', sources.sources_indexation_list,
        name='isearch-sources-indexation-list'),

    url(r'sources/doc_count$', sources.doc_count, name='isearch-sources-doc-count'),

    url(r'sources/indexation/stop$', sources.sources_stop_indexation,
        name='isearch-sources-stop-indexation'),
    url(r'sources/indexation/new$', sources.sources_new_indexation,
        name='isearch-sources-new-indexation'),
    url(r'sources/indexation/repeat$', sources.sources_repeat_indexation,
        name='isearch-sources-repeat-indexation'),
    url(r'sources/indexation/all$', sources.sources_all_indexations,
        name='isearch-sources-all-indexations'),
    url(r'sources/indexation/fail_all$', sources.sources_fail_indexations,
        name='isearch-sources-fail-indexations'),

    url(r'features/user/(.+)/$', features.features_user, name='features_user'),
    url(r'features/group/([a-z][a-z0-9_-]+)/$', features.features_group, name='features_group'),
    url(r'features/add_feature$', features.add_feature, name='add_feature'),
    url(r'features/del_feature$', features.del_feature, name='del_feature'),

    url(r'formula/viewer/$', formula.formulas, name='isearch-formula'),
    url(r'formula/delete/([0-9]+)$', formula.delete_formula, name='isearch-formula-delete'),
    url(r'formula/add/$', formula.add_formula, name='isearch-formula-add'),

    url(r'external_wizard_rules/viewer/$', external_wizard_rules.rules,
        name='isearch-external-wizard-rules'),
    url(r'external_wizard_rules/manage/$', external_wizard_rules.manage_rule,
        name='isearch-external-wizard-rule-manage'),

    url(r'pushes/$', pushes.dashbord, name='push_dashbord'),
    url(r'pushes/dashbord/$', pushes.dashbord, name='push_dashbord'),
    url(r'pushes/log/(\w+)$', pushes.push_log, name='push_log'),
    url(r'pushes/push/(\w+)$', pushes.push_info, name='push_info'),
    url(r'pushes/push/(\w+)/meta.json$', pushes.push_meta_json, name='push_meta_json'),
    url(r'pushes/push/(\w+)/restart$', pushes.push_restart, name='push_restart'),
    url(r'pushes/push/(\w+)/mark_as_known$', pushes.push_mark_as_known, name='push_mark_as_known'),

    url(r'jobs/list/$', jobs.job_list, name='jobs-list'),
    url(r'jobs/fail$', jobs.job_fail, name='job-fail'),
    url(r'jobs/list/(\d+)$', jobs.job_view, name='job-view'),

    url(r'profiles/list/(\w+)/$', profile.profile_list, name='profile-list'),

    url(r'organizations/?$', organization.organization_list, name='isearch-organization-list'),
    url(r'organizations/(\d+)/?$', organization.organization_details,
        name='isearch-organization-details'),
]
