from django.core.paginator import Paginator, PageNotAnInteger, EmptyPage


def paginate(object_list, page=1, per_page=100):
    paginator = Paginator(object_list, per_page)

    try:
        paginated_list = paginator.page(page)
    except PageNotAnInteger:
        paginated_list = paginator.page(1)
    except EmptyPage:
        paginated_list = paginator.page(paginator.num_pages)
    return paginated_list
