from django.forms import ChoiceField
from intranet.search.core.utils import get_scopes


class ScopeField(ChoiceField):
    def __init__(self, choices=(), required=True, widget=None, label=None,
                 initial=None, help_text='', *args, **kwargs):
        scopes = get_scopes()
        choices = list(zip(scopes, scopes))
        super().__init__(choices=choices, required=required, widget=widget, label=label, initial=initial,
                         help_text=help_text, *args, **kwargs)
