import json

from django.core.paginator import Paginator, EmptyPage, PageNotAnInteger
from django.shortcuts import get_object_or_404, redirect

from intranet.search.core.models import Job
from intranet.search.core.storages import JobStorage
from intranet.search.admin import template


def job_list(request):
    module_name = request.GET.get('module_name', None)
    jobs = Job.objects.all().order_by('-id')

    if module_name:
        jobs = jobs.filter(job_name=module_name.strip())

    paginator = Paginator(jobs, 100)

    page = request.GET.get('page')

    try:
        cur_jobs = paginator.page(page)
    except PageNotAnInteger:
        cur_jobs = paginator.page(1)
    except EmptyPage:
        cur_jobs = paginator.page(paginator.num_pages)

    return template.render(
        request=request,
        template='isearch/jobs/jobs-list.html',
        context={'jobs': cur_jobs},
        content_type='text/html',
    )


def job_view(request, job_id):
    job = get_object_or_404(Job, pk=job_id)
    job.options = json.loads(job.options)

    return template.render(
        request=request,
        template='isearch/jobs/job.html',
        context={'job': job},
        content_type='text/html',
    )


def job_fail(request):
    job_id = request.POST.get('failed_job_id', '1')
    job = get_object_or_404(Job, pk=job_id)
    JobStorage().finish(job.id,
                        'Failed manualy by %s' % request.user.username, fail=True)
    return redirect(job_list)
