from django.http import HttpResponseForbidden


def superuser_only_middleware(get_response):
    def middleware(request):
        if not request.user.is_authenticated() or not request.user.is_superuser:
            return HttpResponseForbidden('You don\'t have permission')

        response = get_response(request)
        return response

    return middleware
