import os

from intranet.search.settings.django.settings import *  # noqa: ImportStarUsed


BASE_DIR = '/intrasearch/admin/'

if bool(int(os.environ.get('ISEARCH_ADMIN_DB_MASTER_ONLY', 0))):
    # Ходим всегда в мастер
    REPLICATED_DATABASE_SLAVES = []


STATIC_ROOT = os.path.join(BASE_DIR, 'static')
STATIC_URL = '/_admin/static/'

MIDDLEWARE.extend([  # noqa: ImportStarUsage
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django_yauth.middleware.YandexAuthMiddleware',
])

if yenv.type != 'development':  # noqa: ImportStarUsage
    MIDDLEWARE.extend([  # noqa: ImportStarUsage
        'django_yauth.middleware.YandexAuthRequiredMiddleware',
        'intranet.search.admin.middleware.superuser_only_middleware',
    ])


TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.jinja2.Jinja2',
        'OPTIONS': {
            'environment': 'intranet.search.admin.template.environment',
            'loader': '',
            'context_processors': [
                'django.template.context_processors.i18n',
                'django.template.context_processors.debug',
                'django.template.context_processors.request',

                'django_yauth.context.yauth',
                'django.contrib.auth.context_processors.auth',
                'intranet.search.admin.context_processors.yenv_type',
            ],
        },
    },
    {
        'BACKEND': 'library.python.django.template.backends.arcadia.ArcadiaTemplates',
        'OPTIONS': {
            'debug': False,
            'loaders': [
                'library.python.django.template.loaders.resource.Loader',
                'library.python.django.template.loaders.app_resource.Loader',
            ]
        },
    },
]

FORM_RENDERER = 'library.python.django.template.backends.forms_renderer.ArcadiaRenderer'

STATICFILES_FINDERS = [
    'django.contrib.staticfiles.finders.FileSystemFinder',
    'django.contrib.staticfiles.finders.AppDirectoriesFinder',
    'library.python.django.contrib.staticfiles.finders.ArcadiaAppFinder'
]

INSTALLED_APPS.extend([  # noqa: ImportStarUsage
    'django.contrib.sessions',
    'django.contrib.messages',

    'django_yauth',
    'django.forms',
    'intranet.search.admin',
])

ROOT_URLCONF = 'intranet.search.admin.urls'

from django_yauth.settings import *  # noqa: ImportStarUsed

YAUTH_TYPE = 'intranet'
YAUTH_USE_NATIVE_USER = True
YAUTH_CREATE_USER_ON_ACCESS = True
YAUTH_USE_SITES = False

YAUTH_TVM2_CLIENT_ID = TVM2_CLIENT_ID  # noqa: ImportStarUsage
YAUTH_TVM2_SECRET = TVM2_SECRET  # noqa: ImportStarUsage
YAUTH_USE_TVM2_FOR_BLACKBOX = True
YAUTH_MECHANISMS = ['django_yauth.authentication_mechanisms.cookie']
