
$(document).ready(function () {
    var input = $('.suggest_input');
    input.on('input', _.throttle(function () {
        suggest();
    }, 300));
    // одноразово вызываем саджест при старте, если форма уже заполнена
    if (input.val()) {
        suggest();
    }
});

var requests_info_tmpl = _.template('Запросы к SaaS: ' +
    '<% _.each(requests, function (r) { %>' +
        '<span><a href="<%= r.endpoint %>&fsgta=_JSONFactors&dbgrlv=da"><%= r.name %></span> ' +
    '<% }); %>');

function suggest() {
    var $elem = $("#result");
    var $placeholder = $("#flot-placeholder");
    var $requests_placeholder = $("#requests-placeholder");
    var show_timings = $("#id_show_timings").prop('checked');

    $.ajax({
        url : "{{ url('isearch-suggest') }}",
        type : "GET",
        data : $('#suggest_form').serialize(),
        dataType: "json",

        success : function(json) {
            if (show_timings && json.requests){
                $placeholder.attr("style", "height:150px");
                var plot = $.plot($placeholder, json.requests.values, {
                    yaxis:{ticks:json.requests.labels}
                });
            }
            else {
                delete_timings($placeholder);
            }
            if (json.requests_info) {
                $requests_placeholder.html(requests_info_tmpl({
                    requests: _.filter(
                        json.requests_info,
                        function (r) {return r['type'] == 'search'}
                    )
                }));
            } else {
                $requests_placeholder.empty()
            }

            $elem.text(JSON.stringify(json.result, null, 2));
        },

        error : function(xhr, errmsg, err) {
            var text = 'Error: '+ errmsg + '\n' + err;
            if (xhr.responseText) {
                try {
                    text += '\n' + JSON.stringify(JSON.parse(xhr.responseText), null, 2)
                } catch(e) {
                    text +=  '\n' + xhr.responseText;
                }
            }
            $elem.text(text);
            delete_timings($placeholder);
        }
    });
}

function delete_timings($placeholder) {
    $placeholder.attr("style", "height:0px");
    $placeholder.empty();
}
