from django.conf.urls import url

from . import views

urlpatterns = [
    url(r'^revisions/$', views.RevisionsApiView.as_view(), name='revisions-get'),
    url(r'^features/$', views.FeaturesApiView.as_view(), name='features-get'),
    url(r'^formulas/$', views.FormulasApiView.as_view(), name='formulas-get'),
    url(r'^facet_labels/$', views.FacetLabelsApiView.as_view(), name='facets-get-labels'),
    url(r'^group_attrs/$', views.GroupAttrsApiView.as_view(), name='group-attrs-get-data'),
    url(r'^external_wizard_rules/$', views.RulesApiView.as_view(),
        name='external-wizard-rules-get'),
    url(r'^services/$', views.ServicesApiView.as_view(), name='services-get'),
    url(r'^permissions/$', views.PermissionsApiView.as_view(), name='permissions-get'),
    url(r'^indexer/(?P<search>[\w_-]+)/(?:(?P<index>[\w_-]+)/)?$',
        views.IndexResourceApiView.as_view(), name='indexer-index-resource'),
    url(r'^directory/event/?$',
        views.DirectoryEventHandlerApiView.as_view(), name='directory-event-add'),
    url(r'^directory/sync/?$',
        views.DirectorySyncOrganizationApiView.as_view(), name='directory-sync'),
    url(r'^marks/?$', views.MarksApiView.as_view(), name='marks'),
    url(r'^suggest-answer/$', views.AnswerApiView.as_view(), name='suggest-answer'),
    url(r'^users/meta/?$', views.UserMetaApiView.as_view(), name='users-meta'),
]
