from intranet.search.core.models import SuggestedAnswer

from .base import ModernFormApiView
from ..forms import SuggestAnswerForm


class AnswerApiView(ModernFormApiView):
    """
    Оценка релевантности документа в поисковой выдаче
    """
    form_class = SuggestAnswerForm
    http_method_names = ['post', 'options']

    def get_form(self, *args, **kwargs):
        query = kwargs.get('json', {})
        return SuggestAnswerForm(**query)

    def get_response_data(self, form):
        answer = SuggestedAnswer.objects.create(**form.data)
        return {
            'id': answer.id,
        }
