from intranet.search.core import storages, context

from .base import FormApiView
from ..forms import ApiUserForm


class FeaturesApiView(FormApiView):
    """ Получение списка фич для пользователя
    """
    form_class = ApiUserForm

    def get_response_data(self, form):
        user = form.user.data
        groups = form.groups.data

        repository = storages.StorageRepository()
        features = context.FeaturesContext.from_storage(repository, user, groups)
        return features.to_raw()
