from intranet.search.core import storages, context

from .base import FormApiView


class FormulasApiView(FormApiView):
    """ Получение списка всех формул
    """

    def get_response_data(self, form):
        repository = storages.StorageRepository()
        formulas = context.FormulaContext.from_storage(repository)

        # Хак для того, чтобы можно было заводить мета-поиски вне intrasearch-wiki
        # Чтобы работать с формулой, она должна иметь какой-то сервис
        # но выбиралка формул в надметапоиске ожидает, что у мета-формулы сервиса нет
        formulas = formulas.to_raw()
        for f in formulas:
            if f['search'] == 'meta':
                f['service'] = ''

        return formulas
