from django.utils.encoding import force_str

from .base import FormApiView
from ..forms import ApiArtefactForm


class GroupAttrsApiView(FormApiView):
    """ Получение списка значений групповых атрибутов
    """
    form_class = ApiArtefactForm

    def get_response_data(self, form):
        storage = form.get_storage('group_attr')
        values_group_attrs = storage.get(value__in=form.values.data, name=form.name.data)

        res = {}
        label_field = 'label_%s' % form.language.data
        an_label_field = 'label_%s' % ('ru' if form.language.data == 'en' else 'en')

        for ga in values_group_attrs:
            res[ga['value']] = {
                'label': force_str(ga[label_field] or ga[an_label_field]),
                'url': force_str(ga['url']),
                'name': force_str(ga['name']),
            }
        return res
