from intranet.search.core.models import Mark

from .base import FormApiView
from ..forms import SearchApiMarkForm, SuggestApiMarkForm


class MarksApiView(FormApiView):
    """
    Оценка релевантности документа в поисковой выдаче
    """
    http_method_names = ['post', 'options']

    def get_form(self, *args, **kwargs):
        user = kwargs.get('user')
        query = kwargs.get('json', {})
        if query:
            query['uid'] = user.uid if user else None

        if query.get('mode') == 'suggest':
            return SuggestApiMarkForm(**query)
        return SearchApiMarkForm(**query)

    def get_response_data(self, form):
        mark = Mark.objects.create(**form.data)
        return {
            'id': mark.id,
            'score': mark.score,
        }
