from django.contrib.auth import get_user_model

from intranet.search.core.models import SUGGEST_PERMISSION_PREFIX, SEARCH_PERMISSION_PREFIX
from intranet.search.api.api1.forms import ApiUserForm
from .base import FormApiView

User = get_user_model()


class PermissionsApiView(FormApiView):
    """ Получение списка пермишшенов пользователя
    """
    form_class = ApiUserForm

    def get_response_data(self, form):
        user = User.objects.get(username=form.user.data)
        permissions = self.format_permissions(user.get_all_permissions())
        if user.is_superuser:
            permissions['common'].append('is_superuser')
        return permissions

    def format_permissions(self, permissions):
        result = {
            'common': [],   # общие разрешения
            'search': [],   # разрешённые вертикали в поиске
            'suggest': [],  # разрешённые слои в саджесте
        }
        for perm in permissions:
            app_label, codename = perm.split('.')
            if codename.startswith(SUGGEST_PERMISSION_PREFIX):
                layer = codename[len(SUGGEST_PERMISSION_PREFIX):]
                result['suggest'].append(layer)
            elif codename.startswith(SEARCH_PERMISSION_PREFIX):
                scope = codename[len(SEARCH_PERMISSION_PREFIX):]
                result['search'].append(scope)
            else:
                result['common'].append(codename)
        return result
