from intranet.search.core import storages, context
from .base import FormApiView
from ..forms import ApiRevisionForm


class RevisionsApiView(FormApiView):
    """ Получение списка ревизий
    """
    form_class = ApiRevisionForm

    def get_response_data(self, form):
        repository = storages.StorageRepository()
        groups = form.groups.data
        organization = repository['organization'].get_by_directory_or_label(form.organization.data)
        search_context = context.SearchContext.from_storage(repository, form.user.data,
                                                            groups=groups,
                                                            organization=organization['id'])

        query_context = context.QueryContext.from_kwargs(user=form.user.data,
                                                         features=form.features.data)
        search_context.replace(query=query_context)
        return search_context.revisions.to_raw()
