from django.contrib.auth import get_user_model

from intranet.search.api.api1.forms import ApiUserForm
from .base import FormApiView


User = get_user_model()


class UserMetaApiView(FormApiView):
    """
    Мета-информация о пользователе
    """
    form_class = ApiUserForm

    def get_response_data(self, form):
        user = User.objects.get(username=form.user.data)
        # Note: чтобы не гонять лишнего по сети,
        # отдаём только реально нужные сейчас данные
        return {
            'frequently_searched_people': user.frequently_searched_people or {},
            'recently_searched_people': user.recently_searched_people or {},
        }
