import requests
from django.conf import settings

from intranet.search.core.utils import get_oauth_header, get_oauth_token


def request_abovemeta(text, token_type='oauth_common', scope='wikisearch', **kwargs):
    query = {'scope': scope, 'text': text, 'format': 'json', 'feature.saas_timeout': 10}
    query.update(kwargs)
    url = settings.ISEARCH['abovemeta']['abovemeta'].url(query=query)
    headers = get_oauth_header(get_oauth_token(token_type))
    response = requests.get(url, verify=settings.ISEARCH_CA_CERTS, headers=headers)
    return response.json()
