import os

from intranet.search.settings.django.settings import *  # noqa: ImportStarUsed
from django_alive.settings import *  # noqa: ImportStarUsed
from django_idm_api.settings import *  # noqa: ImportStarUsed

BASE_DIR = os.path.dirname(__file__)

ROOT_URLCONF = 'intranet.search.api.urls'
APP_NAME = os.environ.get('APP_NAME', 'isearch')

MIDDLEWARE.insert(0, 'intranet.search.api.middleware.AliveMiddleware')  # noqa: ImportStarUsage
MIDDLEWARE.insert(0, 'django_idm_api.middleware.TVMMiddleware')  # noqa: ImportStarUsage
MIDDLEWARE.insert(0, 'intranet.search.api.middleware.LogContextMiddleware')  # noqa: ImportStarUsage
MIDDLEWARE.insert(0, 'intranet.search.api.middleware.I18NMiddleware')  # noqa: ImportStarUsage
if APP_NAME == 'isearch':
    MIDDLEWARE.insert(0, 'django_yauth.middleware.YandexAuthMiddleware')  # noqa: ImportStarUsage
MIDDLEWARE.insert(0, 'corsheaders.middleware.CorsMiddleware')  # noqa: ImportStarUsage


INSTALLED_APPS.extend([  # noqa: ImportStarUsage
    'django_alive',
    'django_idm_api',
    'intranet.search.api',
    'corsheaders',
    'django_yauth',
])

REPLICATED_VIEWS_OVERRIDES = {
    'revisions-get': 'slave',
    'features-get': 'slave',
    'formulas-get': 'slave',
    'facets-get-labels': 'slave',
    'group-attrs-get-data': 'slave',
}

IDM_API_TVM_SETTINGS = {
    'client_id': TVM2_CLIENT_ID,  # noqa: ImportStarUsage
    'secret': TVM2_SECRET,  # noqa: ImportStarUsage
}

CORS_ALLOWED_ORIGIN_REGEXES = [
    r'^https://[\w.-]*\.yandex-team\.ru(?::\d{2,5})?(\/.*?)?$',
]
CORS_URLS_REGEX = r"^/api/v1/.*$"
CORS_ALLOW_HEADERS = ('Content-Type', 'Accept-Language')
CORS_ALLOW_METHODS = ('GET', 'POST', 'OPTIONS')
CORS_ALLOW_ALL_ORIGINS = False
CORS_ALLOW_CREDENTIALS = True

from django_yauth.settings import *  # noqa: ImportStarUsed

YAUTH_TYPE = 'intranet'
YAUTH_USE_SITES = False

YAUTH_TVM2_CLIENT_ID = TVM2_CLIENT_ID  # noqa: ImportStarUsage
YAUTH_TVM2_SECRET = TVM2_SECRET  # noqa: ImportStarUsage
YAUTH_USE_TVM2_FOR_BLACKBOX = True
YAUTH_MECHANISMS = ['django_yauth.authentication_mechanisms.cookie']
