import requests

from django.conf import settings
from intranet.search.core.tvm import tvm2_client


class BlackBoxClient:
    """ Класс для работы с API BlackBox
    """
    base_api = settings.ISEARCH['api']['blackbox']

    def __init__(self):
        self.session = requests.Session()

    def get_user_ticket(self, oauth_token):
        """ Меняет oauth_token на user_ticket
        """
        url = self.base_api.url()
        self.session.headers[settings.TVM2_SERVICE_HEADER] = tvm2_client.get_service_ticket('blackbox')
        response = self.session.get(url, params={
            'userip': '127.0.0.1',
            'method': 'oauth',
            'oauth_token': oauth_token,
            'get_user_ticket': 'yes',
        })

        response.raise_for_status()
        data = response.json()
        return data['user_ticket']


blackbox_client = BlackBoxClient()
