from logging import getLogger

from django.core.management.base import BaseCommand

from intranet.search.core.sources.directory.client import DirectoryApiClient

logger = getLogger(__name__)


class Command(BaseCommand):
    help = 'Команда подписки на события директории'

    def add_arguments(self, parser):
        parser.add_argument('--url', '-u', action='store', help='url for webhook events')
        parser.add_argument('--event_names', '-e', action='store', default='',
                            help='comma separated list of events')

    def handle(self, **options):
        dir_client = DirectoryApiClient()

        kwargs = {'event_url': options['url']}
        if options['event_names']:
            kwargs['event_names'] = options['event_names'].split(',')

        result = dir_client.add_webhook(**kwargs)
        logger.info('Webhook added. Result: %s', repr(result))
