from django.core.management.base import BaseCommand

from intranet.search.core.utils.ydeploy import get_celery_beats_config


TEMPLATE = """[program:celery-beat-{name}]
user=www-data
command=isearch-celery beat
    -C -q -l {loglevel} -f beat-{name}
    --pidfile=/var/run/pid/isearch/celery-beat-{name}.pid
    --schedule=/var/run/yandex/intrasearch/celery-beat-{name}-schedule
    -A intranet.search.core.celery.{app}_app
stderr_logfile=/dev/stderr
stderr_logfile_maxbytes=0
stdout_logfile=/dev/stdout
stdout_logfile_maxbytes=0
"""


class Command(BaseCommand):
    help = 'Генерирует опции для запуска celery-beat'

    def add_arguments(self, parser):
        parser.add_argument('--names-only', '-n', action='store_true', default=False)

    def handle(self, **options):
        for name, data in get_celery_beats_config():
            if options['names_only']:
                print(f'celery-beat-{name}')
            else:
                print(TEMPLATE.format(**data))
