from django.core.management.base import BaseCommand

from intranet.search.core.storages import FerrymanTableStorage
from intranet.search.core.storages.job_storage import job_status
from intranet.search.core.ferryman_client import FerrymanClient


class Command(BaseCommand):
    help = 'Команда обновления статуса запушенных в YT таблиц'

    @job_status
    def handle(self, **options):
        storage = FerrymanTableStorage()
        for table in storage.get_active():
            cl = FerrymanClient(service=table['revision']['service'])
            data = cl.get_batch_status(table['batch_id'])
            storage.set_status(table['id'], data['status'])
