from django.core.management.base import BaseCommand
from django.conf import settings
from intranet.search.core.tasks.logbroker import LogbrokerConsumer


class Command(BaseCommand):
    help = 'Reset all messages in logbroker'

    def handle(self, **options):
        config = settings.ISEARCH['logbroker']

        handler = StubHandler()
        consumer = LogbrokerConsumer(**config['consumer'])
        # у логброкера нет способа скинуть просто сразу все сообщения,
        # поэтому нужно их прочитать и закоммитить оффсет последнего
        consumer.read(handler)


class StubHandler:
    def process(self, data):
        pass

    def flush(self):
        pass
