from django.core.management.base import BaseCommand

from intranet.search.core.swarm.tasks import reindex
from intranet.search.core.swarm.indexer import Indexer, STORAGES


class Command(BaseCommand):
    help = 'Make and deploy new index'

    def add_arguments(self, parser):
        parser.add_argument('search', type=str)

        parser.add_argument('--dry-run', '-d', action='store_true',
                            default=Indexer.default_options['dry_run'],
                            help='no act just print commands')
        parser.add_argument('--limit', '-o', action='store', type=int,
                            default=Indexer.default_options['limit'],
                            help='maximum documents number to index')
        parser.add_argument('--stubdir', '-u', action='store',
                            default=Indexer.default_options['stubdir'],
                            help='directory to get pages from')
        parser.add_argument('--noqueue', '-q', action='store_true',
                            default=Indexer.default_options['noqueue'],
                            help='don\'t add task to queue')
        parser.add_argument('--threads', '-a', action='store', type=int,
                            default=Indexer.default_options['threads'],
                            help='number of indexation threads for platform')
        parser.add_argument('--ts', '-g', action='store',
                            default=Indexer.default_options['ts'],
                            help='index only documents changed after given ts')
        parser.add_argument('--debug', '-i', action='store_true',
                            default=Indexer.default_options['debug'],
                            help='turn on debug logging')
        parser.add_argument('--priority', '-p', action='store', type=int,
                            default=Indexer.default_options['priority'],
                            help='task priority')
        parser.add_argument('--nort', '-n', action='store_true', default=False,
                            help='turn realtime indexation off')
        parser.add_argument('--shadow-revision', '-l', action='store_true',
                            default=Indexer.default_options['shadow_revision'],
                            help='do not make revision active')
        parser.add_argument('--global', '-G', action='store_true',
                            default=Indexer.default_options['global'],
                            help='use global queues only')

        parser.add_argument('--keys', '-k', action='store', default='',
                            help='comma separated list of queueus/clusters to index')

        parser.add_argument('--index', '-s', action='store', default='', help='index name')
        parser.add_argument('--nolock', action='store_true', default=False,
                            help='do not use locking')
        parser.add_argument('--lock-timeout', '-t', action='store', default='4h',
                            help='lock timeout')
        parser.add_argument('--new-revision', '-x', action='store_true', default=False,
                            help='create new revision')
        parser.add_argument('--service', '-r', action='store', default='',
                            help='service name for platform')
        parser.add_argument('--revision-id', '-w', action='store', default='',
                            help='new revision id')
        parser.add_argument('--use-ts', '-b', action='store_true', default=False,
                            help='index only documents changed after latest successful indexation')
        parser.add_argument('--comment', '-c', action='store', default='',
                            help='add comment to indexation')
        parser.add_argument('--load-percent', '-L', action='store', default=50,
                            help='percent of celery workers in this indextion, default 50')
        parser.add_argument('--no-check', '-N', action='store_true', default=False,
                            help='Do not use check to stop indexation, default false')
        parser.add_argument('--suffix', '-S', action='store', default='',
                            help='suffix for walk swarm step')
        parser.add_argument('--organizations', '-O', action='store', default='',
                            help='organization directory id OR label (comma-separated list)')
        parser.add_argument('--organizations-limit', '-T', action='store', type=int, default=1000,
                            help='maximum count of organizations in one indexation, '
                                 'organizations will be sorted by last indexation end_date')
        parser.add_argument('--revision-ttl', action='store', default='',
                            help='ttl of revision, when it is reached, new revision will be created, '
                                 'even without --new-revision options')
        parser.add_argument('--document_storages', '--storages', action='store',
                            default=','.join(Indexer.default_options['document_storages']),
                            help='comma separated types of storages, available types: %s' % ', '.join(STORAGES.keys()))
        parser.add_argument('--from-cache', action='store_true', default=False,
                            help='Index from YT cache table')
        parser.add_argument('--cache-table', action='store', default='',
                            help='YT table for indexation from cache')

    def handle(self, search, **options):
        reindex(search, **options)
