from django.conf import settings
from django.core.management.base import BaseCommand


TEMPLATE = """
<Controller>
    <HttpOptions>
        Port : 19025
        Threads: 5
    </HttpOptions>
</Controller>
<Server>
    Log: /dev/stderr
    TvmLog: /dev/stderr
    LogbrokerLog: /dev/stderr
    LogLevel: 6
    <SearchMap>
        Ctype: {ctype}
        DMHost: saas-dm-proxy.n.yandex-team.ru
        StaticaHost: saas-searchmap.s3.mds.yandex.net
        StaticaQuery: {ctype}
    </SearchMap>
    <Writer>
        <HttpOptions>
            Port: 19024
            Threads: 5
            KeepAlive: true
            Compression: true
        </HttpOptions>
        MessagesLog: /dev/stderr
        {services}
    </Writer>
</Server>
<Telemetry>
    Interval: 10m
    Server: {telemetry_host}
</Telemetry>
"""

SERVICE_TEMPLATE = """
        <Service>
            Alias: {name}
            Name: {name}
            Ctype: {ctype}
            Server: {logbroker_host}
            TopicsDir: /saas/services/{name}/{ctype}/topics
            Format: Json
            <TVM>
                ClientId: {tvm_id}
                Secret: {tvm_secret}
                DestinationAlias: pq_{dst_tvm_id}
                DestinationClientId: {dst_tvm_id}
            </TVM>
            LoggingEnabled: {logging_enabled}
            <CheckMessage>
                Disabled : 0
                Attributes : 1
                KeyPrefixType : non_zero
                MaxSizeBytes : {max_size_bytes}
            </CheckMessage>
        </Service>
"""


MAX_SIZE_BYTES_DEFAULT = 7340032


class Command(BaseCommand):
    help = 'Генерирует конфиг для пуш клиента сааса'

    def handle(self, **options):
        services_conf = []
        ctype = 'stable' if settings.YENV_TYPE == 'production' else 'prestable'

        for service in settings.ISEARCH['api']['saas'].keys():
            if settings.ISEARCH['api']['saas'][service]['indexer'].get('deprecated'):
                saas_push_client_key = 'deprecated'
            else:
                saas_push_client_key = 'new'

            params = {
                'name': service,
                'ctype': ctype,
                'logbroker_host': settings.ISEARCH['saas_push_client'][saas_push_client_key]['logbroker_host'],
                'tvm_id': settings.TVM2_CLIENT_ID,
                'tvm_secret': settings.TVM2_SECRET,
                'dst_tvm_id': settings.ISEARCH['saas_push_client'][saas_push_client_key]['dst_tvm_id'],
                'logging_enabled': 'true' if settings.DEBUG else 'false',
                'max_size_bytes': settings.ISEARCH['api']['saas'][service]['indexer'].get(
                    'max_size_bytes',
                    MAX_SIZE_BYTES_DEFAULT,
                ),
            }
            services_conf.append(SERVICE_TEMPLATE.format(**params))

        params = {
            'ctype': ctype,
            'telemetry_host': settings.ISEARCH['saas_push_client']['telemetry_host'],
            'services': ''.join(services_conf),
        }
        conf = TEMPLATE.format(**params)
        print(conf)
