from django.core.management.base import BaseCommand

from intranet.search.core.tasks import sync_directory_organization

from intranet.search.core import storages
from intranet.search.core.sources.directory.client import DirectoryApiClient


class Command(BaseCommand):
    help = 'Базовая команда синка с директорией'

    def add_arguments(self, parser):
        parser.add_argument('--existed', '-e', action='store_true', help='sync already existed organizations')

    def handle(self, **options):
        dir_repo = storages.StorageRepository()['organization']
        dir_client = DirectoryApiClient()

        if options['existed']:
            for org in dir_repo.get_all():
                sync_directory_organization(org)
        else:
            url = None
            current_page = 1
            while current_page or url:
                if url:
                    page_data = dir_client._do_request(url)
                else:
                    page_data = dir_client.get_organizations(page=current_page)

                for org in page_data['result']:
                    dir_repo.update_from_directory_data(org)

                current_page = 0
                url = page_data.get('links', {}).get('next')
