from urllib.parse import parse_qsl

# максимальной значение dwell_time. YQL ломается, если оно выходит за границы Int64
MAX_DWELL_TIME = 2 ** 63 - 1


class Row:
    def __init__(self, **kwargs):
        for key, value in kwargs.items():
            setattr(self, key, value)


def parse_query(query):
    parsed = dict(parse_qsl(query))
    return parsed


def get_query_data(request):
    if not request.ProcessedQuery:
        return {}
    query = parse_query(request.ProcessedQuery)
    data = dict(
        zone=query.get('intrasearch-zone') or '',
        scope=query.get('intrasearch-scope') or '',
        reqid=query.get('intrasearch-reqid') or '',
        wizard_name=query.get('wizard_name') or '',
    )
    return data


def is_intrasearch(request):
    return request.SaasService.startswith('intrasearch') or request.SaasService == 'startrek'


def is_long_click(click, long_click_threshold=120):
    return click['dwell_time'] > long_click_threshold


def shrink_dwell_time(dwell_time):
    return min(dwell_time or 0, MAX_DWELL_TIME)
